#ifndef __OPTINFO_H
#define __OPTINFO_H

/* This library helps building programs using long options
 * Copyright (C) 2002 Bartosz Lis
 */

struct optinfo_t {
  char        short_opt; /* short option character */
  const char *long_opt;  /* long option name */
  const char *comment;   /* comment to print in help message */
  const char *arg_descr; /* NULL if option needn't any argument,
                          * starting with [ if argument is optional
                          * will be printed in help message */
  int        *flag;      /* where to store val if option is choosen */
  int         val;       /* option indicator
                          * both fileds flag and val are copied
                          * to struct option */
};

/* declaration of struct option array basing on struct optinf_t array
 */
#define DECLARE_OPT_ARR(opt_arr, opti_arr) \
struct option opt_arr[sizeof(opti_arr)/sizeof(struct optinfo_t)+1];
#define DECLARE_OPT_ARR_EXTRA(opt_arr, opti_arr, extra) \
struct option opt_arr[sizeof(opti_arr)/sizeof(struct optinfo_t)+1+(extra)];

/* initializes struct option array with values derived from struct optinfo_t
 * array returns number of characters needed for short option definition
 */
size_t
init_long_options (struct option *opt_arr, const struct optinfo_t *opti_arr,
                   size_t num_opt);

#define INIT_LONG_OPTIONS(opt_arr, opti_arr) \
init_options ((opt_arr),(opti_arr),sizeof(opti_arr)/sizeof(struct optinfo_t))

/* copies short option definitions to optsting
 * does not put trailing 0
 * returns pointer to the first character after last copied option
 */
char *
init_short_options(char *optstring, const struct optinfo_t *opti_arr,
                   size_t num_opt);
#define INIT_SHORT_OPTIONS(optstring, opti_arr) \
init_short_options ((optstring),(opti_arr),sizeof(opti_arr)/sizeof(struct optinfo_t))

/* print help screen to stdout or FILE *f
 */
void
printf_options (const struct optinfo_t *opti_arr, size_t num_opt);

#define PRINTF_OPTIONS(opti_arr) \
printf_options ((opti_arr),sizeof(opti_arr)/sizeof(struct optinfo_t))

void
fprintf_options (FILE *f, const struct optinfo_t *opti_arr, size_t num_opt);

#define FPRINTF_OPTIONS(f, opti_arr) \
fprintf_options (f,(opti_arr),sizeof(opti_arr)/sizeof(struct optinfo_t))

#endif /* __OPTINFO_H */
