#define _GNU_SOURCE
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>

#include "optinfo.h"

#define NON_EMPTY(str) ((str) && *(str))
size_t
init_long_options (struct option *opt_arr, const struct optinfo_t *opti_arr,
                   size_t num_opt)
{
  size_t short_opt_len=0, i;
  int    has_arg;
  for (i=0; (i<num_opt) && opti_arr->long_opt; ++i, ++opti_arr)
  {
    has_arg=(opti_arr->arg_descr ? opti_arr->arg_descr[0]=='[' ? 2 : 1 :0);
    if (opti_arr->long_opt)
    {
      opt_arr->name=opti_arr->long_opt;
      opt_arr->has_arg=has_arg;
      opt_arr->flag=opti_arr->flag;
      opt_arr->val=opti_arr->val;
      ++opt_arr;
    }
    if (opti_arr->short_opt) short_opt_len+=has_arg+1;
  }
  opt_arr->name=0;
  opt_arr->has_arg=0;
  opt_arr->flag=0;
  opt_arr->val=0;
  return short_opt_len;
}

char *
init_short_options(char *optstring, const struct optinfo_t *opti_arr,
                   size_t num_opt)
{
  size_t i;
  for (i=0; (i<num_opt) && opti_arr->long_opt; ++i, ++opti_arr)
    if (opti_arr->short_opt)
    {
      *optstring++=opti_arr->short_opt;
      if (opti_arr->arg_descr)
      {
        *optstring++=':';
        if (opti_arr->arg_descr[0]=='[') *optstring++=':';
      }
    }
  return optstring;
}

void
printf_options (const struct optinfo_t *opti_arr, size_t num_opt)
{
  fprintf_options (stdin,opti_arr,num_opt);
}

void
fprintf_options (FILE *f, const struct optinfo_t *opti_arr, size_t num_opt)
{
  size_t                  i, j, opt_len, max_opt_len=0;
  const struct optinfo_t *opti_p;
  char                   *buff=0;
  size_t                  lengths[num_opt];
  for (i=0, opti_p=opti_arr; (i<num_opt) && opti_p->long_opt; ++i, ++opti_p)
  {
    opt_len=(opti_p->long_opt ? strlen (opti_p->long_opt)+2 : 0);
    if (opti_p->short_opt)
    {
      opt_len+=2;
      if (opti_p->long_opt) opt_len+=1;
    }
    if (opti_p->arg_descr) opt_len+=strlen (opti_p->arg_descr)+1;
    if (max_opt_len<opt_len) max_opt_len=opt_len;
    lengths[i]=opt_len;
  }
  for (i=0, opti_p=opti_arr; (i<num_opt) && opti_p->long_opt; ++i, ++opti_p)
  {
    if (opti_p->short_opt)
    {
      fprintf(f,"-%c",opti_p->short_opt);
      if (opti_p->long_opt) fprintf(f," ");
    }
    if (opti_p->long_opt) fprintf(f,"--%s",opti_p->long_opt);
    if (opti_p->arg_descr) fprintf(f," %s",opti_p->arg_descr);
    for (j=lengths[i]; j<max_opt_len; ++j) fputc(' ',f);
    if (opti_p->comment) fprintf (f," # %s",opti_p->comment);
    fputc('\n',f);
  }
}
