#define _GNU_SOURCE
#include "config.h"

/*
 * banner (c)
 * Copyright (C) 1997 - 2002 Bartosz Leopold Lis <bartoszl@ics.p.lodz.pl>
 */

/*
 * Here is the source code of the ``banner'' program.
 *
 * This program prints its positional parameters with very very big letters
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include "stdfont.h"

#ifndef BANNER_BUGREPORT
#  define BANNER_BUGREPORT "Bartosz Lis <bartoszl@icsp.lodz.pl>"
#endif /*BANNER_BUGREPORT */
#ifndef BANNER_STRING
#  define BANNER_STRING PACKAGE " " VERSION
#endif /*BANNER_STRING*/

#define DEF_LINE_WIDTH 79

int font_num;
int font_width;
int font_height;

void
error_msg (FILE *f, char *progname, const char *msg, int usage, int code)
{
   if (msg) fprintf(f, "%s: %s\n",progname,msg);
   else fprintf(f, BANNER_STRING "\n"
                   "Making text larger for fun\n"
                   "Copyright (C) 1997 - 2002 " BANNER_BUGREPORT "\n"
                   "This program is distributed under the GNU General Public License\n",
                   "For more information see the file COPYING in its sources\n");
   if (usage)
     {
        fprintf(f, "\nUsage: %s [-h | -v | -w <screen size> | -W] [--] <banner text>\n"
                   "where: -h, --help                 -- help screen\n"
                   "       -v, --version              -- version\n"
                   "       -w, --width <screen width> -- sets output width to <screen size>\n"
                   "       -W  --std-width            -- sets output width to default 80 chars\n",
                progname);
     }
   fflush(0);
   exit(code);
}

struct option options[] =
{
  { "help",      no_argument,       0, 'h' },
  { "version",   no_argument,       0, 'v' },
  { "width",     required_argument, 0, 'w' },
  { "std-width", no_argument,       0, 'W' },
  { 0, 0, 0, 0 }
};

char_matrix *font_arr[MAX_FONT_NUM];

void
print_char(char c, int line)
{
   char_matrix *pc=(((unsigned char)c<font_num) ? font_arr[c] : 0);
   if (!pc) pc=&c_unknown;
   printf("%s",(*pc)[line]);
}

void
print_str(char *message, int line_width)
{
   int i,j=0,k;
   if (message) while (*message)
     {
        for (i=0; i<font_height; i++)
          {
             j=k=0;
             while (message[j]
                    && (((k+=font_width)<=line_width) || !line_width || !j))
               print_char(message[j++],i);
             printf("\n");
          }
        message+=j;
     }
}

void
check_arg (int argc, char **argv, int *argi,
           int *line_width)
{
   char c;
   int  i;
   while ((c=getopt_long(argc,argv,"hvw:W",options,0))!=-1) switch (c)
     {
      case 'w':
        if (sscanf(optarg,"%d",i)!=1)
          error_msg(stderr,argv[0],"wrong screen width",1,3);
        *line_width=i;
        break;
      case 'W':
        *line_width=DEF_LINE_WIDTH;
        break;
      case 'h':
        error_msg(stdout,argv[0],0,1,0);
      case 'v':
        error_msg(stdout,argv[0],0,0,0);
      case ':':
        error_msg(stderr,argv[0],"missing parameter for an option",1,3);
      default:
        error_msg(stderr,argv[0],"unknown option",1,3);
     }
   *argi=optind;
}

int
main(int argc, char **argv)
{
   int   i,line_width=0;
   init_default_font();
   check_arg (argc,argv,&i,&line_width);
   while (i<argc) print_str(argv[i++],line_width);
   return 0;
}
