#!/usr/bin/perl

#
# Lista adresów IP i portów docelowych. Każdy IP jes traktowany jak źródłowy
# i docelowy. Elementy listy same będące listami, powodują logowanie zdarzenia,
# drugim elementem takiej listy może być niestandardowy komunikat.
# Szczególnym przypadek występuje, gdy drugim elementem listy jest 'RET',
# taka reguła powoduje przerwanie przetwarzania listy (innymi słowy jest
# to wyjątek z czarnej listy).
#
my @black_list =
(
);

#
# Lista adresów IP i portów docelowych. Każdy IP jes traktowany jak źródłowy
# i docelowy. Elementy listy same będące listami, powodują logowanie zdarzenia,
# drugim elementem takiej listy może być niestandardowy komunikat.
# Szczególnym przypadek występuje, gdy drugim elementem listy jest 'RET',
# taka reguła powoduje przerwanie przetwarzania listy (innymi słowy jest
# to wyjątek z białej listy).
#
my @white_list =
(
);

#
# Lista uprawnionych serwerów SMTP. Znaczek > informuje, czy jest
# to serwer wewnętrzny, czy zewnętrzny
#
my @white_list_smtp =
(
);

@f_input =
(
#    [ '>udp>:7', [ 'JUMP', 'wol',                                       # Wake On LAN
#        [ '>>'.peek_addr('some_net',-2),['GOTO','',['bcast_source>>','ACC'],['','DROP']]],
#    ]],
#    [ '>udp>:67,68', [ 'ACC', 'acc_DHCP_in' ]],                         # DHCP
    [ '@lo>>', 'ACC'],
    [ '>>net_mcast', 'DROP'],
    [ 'net_mcast>>', 'DROP'],
    [ '', [ 'JUMP', 'chk_src_in', 
	(scalar @nic_bridge ? ([ '@'.join(',',@nic_bridge).'>>', 'RET']): ()), 
	[ \%net_src, '', ['DROP', 'spoofing', 10]]
    ]],
    [ '', [ 'JUMP', 'black_list', bw_list('DROP','on_black_list',@black_list)]],
    [ '', [ 'JUMP', 'white_list', bw_list('ACC','on_white_list',@white_list)]],
    [ '&state --state RELATED,ESTABLISHED', 'ACC'],
    [ '&state --state NEW', [ 'GOTO', 'in_new',
	[ '', [ 'JUMP', 'sshguard' ]],
	[ '>tcp>', [ 'GOTO', 'in_tcp',
	    [ '&tcp -p tcp ! --syn', [ 'DROP', 'broken', 10 ]], # packet flowing in a broken connection
	    [ '>tcp>:22', [ 'ACC', 'ssh' ]],                            # SSH
	    [ '>tcp>:113', [ 'GOTO', 'auth',                            # auth
#		[ 'friendly_net>>', [ 'REJ', 'tcp-reset' ]],
		[ '', 'DROP' ],
	    ]],
	]],
	[ '>udp>', [ 'GOTO', 'in_udp',
#	    [ ':500>udp>:500', 'ACC' ],                                 # IPSec/IKE
#	    [ '>udp>:4500', 'ACC' ],                                    # IPSec/IKE/NAT
	    [ '>udp>:33434-33533', 'ACC' ],                             # traceroute
	]],
	[ '>icmp>', [ 'GOTO', 'in_icmp',
	    [ '>icmp-8>', 'ACC' ],                                      # ping
	    [ '@'.$nic_out.'>icmp-5>&physdev ! --physdev-in vif+', [ 'DROP', 'denied-icmp' ]],         # unexpected ping reply
	]],
#	[ '>[50]>', 'ACC' ],                                            # IPSec
    ]],
);

@f_output=
(
    [ '>>@'.$nic_out, [ 'JUMP', '',
	[ '&physdev --physdev-is-bridged --physdev-out vif+', 'RET'],
	[ '', [ 'JUMP', 'chk_out', @rules_out]],
    ]],
#    [ '>[50]>', 'ACC' ],                  # IPSec
);

@f_forward =
(
#    [ '>udp>:69', [ 'LOG', 'tftp' ]],
#    [ '>udp>:7', [ 'JUMP', 'wol' ]],             # Wake On LAN
    [ '>>net_mcast', 'DROP' ],
    [ 'net_mcast>>', 'DROP' ],
    if_nicgroup(\@nic_bridge,'', [ 'chk_src_fw',
	[ '&physdev --physdev-in vif+', 'RET' ],
	[ \%net_src, '', ['DROP', 'spoofing', 10]]
    ]),
    [ '>>@'.$nic_out, [ 'JUMP', '',
	[ '&physdev --physdev-is-bridged --physdev-out vif+', 'RET'],
	[ '', [ 'JUMP', 'chk_out' ]],
    ]],
    [ '', [ 'JUMP', 'black_list' ]],
    [ '', [ 'JUMP', 'white_list' ]],
    if_nicgroup(\@nic_intranet,'ACC'),
    [ '&state --state RELATED,ESTABLISHED', 'ACC'],
    [ '&state --state NEW', [ 'GOTO', 'fw_new', 
	[ '', [ 'JUMP', 'sshguard' ]],
	#
	# TCP
	#
	[ '>tcp>', [ 'GOTO', 'fw_tcp',
	    [ '&tcp -p tcp ! --syn', [ 'DROP', 'broken', 10 ]], # packet flowing in a broken connection
	    [ '>>@'.$nic_out, [ 'JUMP', 'fw_tcp_out',
		[ '&physdev --physdev-is-bridged --physdev-out vif+', 'RET'],
		[ '', [ 'GOTO', '',
		    [ '>tcp>:25', [ 'GOTO', 'trusted_smtp',
			bw_list('ACCEPT','trusted-smtp',@white_list_smtp),
			[ '', [ 'DROP', 'denied-smtp' ]],
		    ]],
		    [ '', ['ACC', 'allowed-outbound' ]],
		]],
	    ]],
	    if_nicgroup(\@nic_bridge,'fw_tcp_out'),
	    [ "&limit --limit 1000/s", [ 'GOTO', 'fw_tcp_lim',
#		service_acl('ftp','>tcp>:21',
#	                   ),
#	        service_acl('ssh','>tcp>:22',
#	                   ),
#	        service_acl('telnet','>tcp>:23',
#	                   ),
#	        service_acl('smtp','>tcp>:25,465,587',
#	                   ),
#	        service_acl('domain','>tcp>:53',
#	                   ),
#	        service_acl('www','>tcp>:80,443',                                                                  # http, https
#	                   ),
#	        service_acl('mail','>tcp>:110,143,220,993,995',                                                    # pop3,imap,imap3,imaps,pop3s
#	                   ),
#	        service_acl('sunrpc','>tcp>:111,1001,1003,2049',                                                   # NFS
#	                   ),
	        [ '>tcp>:113', [ 'GOTO', 'auth#',                                                                  # auth
#		    [ 'friendly_net>>', [ 'REJ', 'tcp-reset' ]],
		    [ '', 'DROP' ],
	        ]],
#	        service_acl('nntp','>tcp>:119',
#	                   ),
#	        service_acl('netbios','>tcp>:137,138,139,445',
#	                   ),
#	        service_acl('ldap','>tcp>:389',
#	                   ),
#	        service_acl('netprint','>tcp>:427,631,9100',
#	                   ),
#	        service_acl('printer','>tcp>:515',
#	                   ),
#	        service_acl('vmware','>tcp>:902',
#	                   ),
#	        service_acl('asynman','>tcp>:1023',
#	                   ),
#	        service_acl('ms-sql-s','>tcp>:1433',
#	                   ),
#		service_acl('cvspserver','>tcp>:2401',
#			   ),
#	        service_acl('mysql','>tcp>:3306',
#	                   ),
#	        service_acl('msts','>tcp>:3389',                                                                   # Terminal services
#	                   ),
#	        service_acl('partimage','>tcp>:4025',
#	                   ),
#	        service_acl('postgresql','>tcp>:5432',
#	                   ),
#	        service_acl('vnc','>tcp>:5500,5800,5900',
#	                   ),
#	        service_acl('tomcat','>tcp>:8000',
#	                  ),
#	        service_acl('webcache','>tcp>:8080',
#	                   ),
	    ]],
	]],
	#
	# UDP
	#
	[ '>udp>', [ 'GOTO', 'fw_udp', 
	    [ '>udp>:53', [ 'GOTO', 'domain#',
		[ '', [ 'JUMP', 'fw_udp_acc_out',
		    [ '>>@'.$nic_out, [ 'JUMP', 'fw_udp_out',
			[ '&physdev --physdev-is-bridged --physdev-out vif+', 'RET'],
			[ '', 'ACC' ],
		    ]],
		    if_nicgroup(\@nic_bridge,'fw_udp_out'),
		]],
	        [ '', 'DROP' ]
	    ]],
#	    [ '>udp>:67,68', [ 'ACC', 'acc_DHCP_fwd' ]]
#	    [ '>udp>:69', [ 'GOTO', 'tftp#',
#	        [ '', 'DROP' ]
#	    ]],
#	    [ '>udp>:123', [ 'GOTO', 'ntp#',
#		[ '', [ 'JUMP', 'fw_udp_acc_out' ]],
#		[ '', 'DROP' ]
#	    ]],
	    [ '>udp>:137,138,139,445', [ 'GOTO', 'netbios#',
	        [ '', 'DROP' ]
	    ]],
#	    [ '>udp>:161', [ 'GOTO', 'snmp#',
#	        [ '', 'DROP' ]
#	    ]],
#	    [ '>udp>:162', [ 'GOTO', 'snmptrap#',
#	        [ '', 'DROP' ]
#	    ]],
#	    [ '>udp>:427,631', [ 'GOTO', 'netprint#',   # drukarki matematyków
#	        [ '', 'DROP' ]
#	    ]],
#	    [ ':500>udp>:500', [ 'GOTO', 'fw_ipsec',     # IP-sec/IKE
#	        [ '', 'DROP' ]
#	    ]],
#	    [ '>udp>:515', [ 'GOTO', 'printer#',
#	        [ '', 'DROP' ]
#	    ]],
#	    [ '>udp>:4500', [ 'GOTO', 'fw_ipsec' ]],     # IP-sec/IKE/NAT
	    [ '>udp>:33434-33533', [ 'GOTO', 'ip_diag',
		[ '', [ 'JUMP', 'fw_udp_acc_out' ]],
	        [ '', 'DROP' ]
	    ]],
	]],
	#
	# ICMP
	#
	[ '>icmp>', [ 'GOTO', 'fw_icmp',
	    [ '>icmp-8>', [ 'GOTO', 'ip_diag' ]],
	    [ '@'.$nic_out.'>icmp-5>&physdev ! --physdev-in vif+', [ 'DROP', 'denied-icmp' ]],
	]],
	#
	# IP-sec
	#
#	[ '>[50]>', [ 'GOTO', 'fw_ipsec' ]],
	#
	# SCTP
	#
	[ '>sctp>', [ 'GOTO', 'fw_sctp',
	    [ '>>@'.$nic_out, [ ($guarded eq '' ? 'GOTO' : 'JUMP'), 'fw_sctp_out', 
		($guarded eq '' ? () : ([ '>>'.$guarded, 'RET' ])),
		[ '>tcp>:25', [ 'GOTO', 'trusted_smtp']],
		[ '', ['ACC', 'allowed-outbound' ]],
	    ]],
	    if_nicgroup(\@nic_bridge,'fw_sctp_out'),
	    [ "&limit --limit 1000/s", [ 'GOTO', 'fw_sctp_lim',
		[ '>sctp>:80,443', [ 'GOTO', 'www_0' ]],                                                                 # http, https
	    ]],
	    ['','DROP'],
	]],
    ]],
);

1;
