/***************************************************************************
                          ann_ws_set.cpp  -  description
                             -------------------
    begin                : czw kwi 17 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_ws_set.h>

  //                   //
 // ANN::WS::create() //
//                   //

ANN::WS *
ANN::WS::create()
{
  return new WS_set;
}
    
  //                   //
 // class ANN::WS_set //
//                   //

ANN::WS_set::~WS_set()
{
}

void
ANN::WS_set::register_weight(W &w)
{
  g_set.insert(w.get_group());
  w_set.insert(&w);
}

void
ANN::WS_set::erase_weights()
{
  g_set.clear();
  w_set.clear();
}

void
ANN::WS_set::reset(NE *ne)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->reset(ne);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->reset(ne);
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->reseted(ne);
}

void
ANN::WS_set::commence(NE &ne)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->commence(ne);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->commence(ne);
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->commenced(ne);
}

void
ANN::WS_set::commit(NE &ne)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->commit(ne);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->commit(ne);
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->commited(ne);
}

void
ANN::WS_set::conclude(NE &ne)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->conclude(ne);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->conclude(ne);
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->concluded(ne);
}

void
ANN::WS_set::randomize()
{
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->randomize();
}

bool
ANN::WS_set::load(Parser_log &parser, time_t begin, time_t end)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    if (!(*git)->load(parser,begin,end)) return false;
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    if (!(*wit)->load(parser,begin,end)) return false;
  return true;
}

void
ANN::WS_set::store(Log &log)
{
  WGs_it git, gend;
  for (git=g_set.begin(), gend=g_set.end(); git!=gend; ++git)
    (*git)->store(log);
  Ws_it wit, wend;
  for (wit=w_set.begin(), wend=w_set.end(); wit!=wend; ++wit)
    (*wit)->store(log);
}  

