/***************************************************************************
                          ann_ts.cpp  -  description
                             -------------------
    begin                : sob maj 3 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_ts.h>

  //               //
 // class ANN::TS //
//               //

ANN::TS::~TS()
{
}

bool
ANN::TS::resize(const Size &limits_, bool keep)
{
  bool ret=TERM::resize(limits_,keep);
  if (dim_div>=size.dim())
  {
    dim_div=size.dim();
    total_term=1;
    total_length=size.total_size();
  }
  else
  {
    total_term=Size(size.dim()-dim_div,size.get_coord()+dim_div).total_size();
    if (dim_div) total_length=Size(dim_div,size.get_coord()).total_size();
    else total_length=1;
  }
  return ret;
}

void
ANN::TS::set_dim_div(size_t dim_div_)
{
  dim_div=(dim_div_>size.dim() ? size.dim() : dim_div_);
  size_t l=size.dim()-dim_div;
  if (l)
  {
    total_term=Size(l,size.get_coord()+dim_div).total_size();
    if (dim_div) total_length=Size(dim_div,size.get_coord()).total_size();
    else total_length=1;
  }  
  else
  {
    total_term=1;
    total_length=size.total_size();
  }
}

bool
ANN::TS::set_limits(const Size &lengths_, const Size &sizes_,
                    bool keep)
{
  Size new_size;
  if (lengths_.total_size()>1) new_size=lengths_;
  dim_div=new_size.dim();
  if (sizes_.total_size()>1) new_size.append(sizes_);
  return resize(new_size,keep);
}

void
ANN::TS::query_lengths(Size &lengths_) const
{
  if (dim_div) lengths_.resize(dim_div,size.get_coord());
  else if (size.total_size()) lengths_.resize(1,1);
  else lengths_.resize();
}

void
ANN::TS::query_sizes(Size &sizes_) const
{
  if (dim_div<size.dim())
    sizes_.resize(size.dim()-dim_div,size.get_coord()+dim_div);
  else if (size.total_size()) sizes_.resize(1,1);
  else sizes_.resize();
}

void
ANN::TS::locate(Term &term, size_t which)
{
  Size size_;
  query_sizes(size_);
  term.resize(size_,false);
  term.set_data(get_data(which));
}

void
ANN::TS::locate(Term &term, const Loc &where)
{
  Size size_;
  query_sizes(size_);
  term.resize(size_,false);
  term.set_data(get_data(where));
}

