/***************************************************************************
                          ann_to.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
 
#include <ann_to.h>

  //                //
 // class ANN::NIT //
//                //

ANN::NIT::~NIT()
{
}

void
ANN::NIT::register_weights(TO &torg_)
{
  torg=&torg_;
}

ANN::NE::Status
ANN::NIT::commence(DS &ds_, bool is_input)
{
  if (is_input && (in_size.total_size()!=ds_.get_size())) return wrong;
  return dumb;
}

void
ANN::NIT::conclude()
{
}

void
ANN::NIT::open()
{  
}

ANN::NE::Status
ANN::NIT::adapt_for(size_t epochs)
{
  return dumb;
}

size_t
ANN::NIT::get_epoch() const
{
  return torg ? torg->get_epoch() : size_max;
}

  //                //
 // class ANN::TOC //
//                //

ANN::TOC::~TOC()
{
}

  //               //
 // class ANN::TO //
//               //

ANN::TO::~TO()
{
}

void
ANN::TO::embed(NIT &trainee_)
{
  trainee=&trainee_;
  trainee->register_weights(*this);
  trainee->reset(false);
  ws->reset(this);
  out_data.resize(trainee->get_out_sizes());
}

void
ANN::TO::register_weight(W &w)
{
  ws->register_weight(w);
}

const ANN::Size &
ANN::TO::get_out_sizes() const
{
  return trainee->get_out_sizes();
}

size_t
ANN::TO::get_out_size() const
{
  return trainee->get_out_size();
}

ANN::NE::Status
ANN::TO::feed(const Term &in, Term &out)
{
  return trainee->feed(in,out);
}

void
ANN::TO::reset(bool prod)
{
  epoch=0;
  ws->erase_weights();
  if (!prod) trainee->register_weights(*this);
  trainee->reset(prod);
  ws->reset(prod ? 0 : this);
}

bool
ANN::TO::load(Parser_log &parser, time_t begin, time_t end)
{
  return trainee->load(parser,begin,end) && ws->load(parser,begin,end);
}

void
ANN::TO::store(Log &log_)
{
  trainee->store(log_);
  ws->store(log_);
}

void
ANN::TO::randomize()
{
  trainee->randomize();
  ws->randomize();
}

ANN::NE::Status
ANN::TO::adapt_for(size_t epochs)
{
  Status ret;
  if (log) log->commence(label);
  if (((ret=trainee->commence(*ds,true))==wrong) || !epochs)
  {
    if (log) log->concluded(epoch);
    return ret;
  }  
  ws->commence(*this);
  for (size_t i=0; (i<epochs) && ((ret==not_yet) || (ret==dumb)); ++i, ++epoch)
    ret=adapt_internal();
  if (log) log->conclude(epoch);
  ws->conclude(*this);
  trainee->conclude();
  if (log) log->concluded(epoch);
  return ret;
}

size_t
ANN::TO::get_epoch() const
{
  return epoch;
}

