/***************************************************************************
                          ann_tc_set.cpp  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <vector>

#include <ann_tc_set.h>

  //                   //
 // ANN::TC::create() //
//                   //

ANN::TC *
ANN::TC::create()
{
  return new TC_set;
}

  //                   //
 // class ANN::TC_set //
//                   //

bool
ANN::TC_set::TokenCmp::operator ()(const Token *t1, const Token *t2) const
{
  if (t1->seq!=t2->seq) return t1->seq<t2->seq;
  short ret=t1->where.cmp(t2->where);
  return (ret ? ret : t1->loc.cmp(t2->loc))<0;
}

ANN::TC_set::~TC_set()
{
  do_clear();
}

void
ANN::TC_set::do_recalc()
{
  std::vector<Size *>  size_;
  TSIterator           it=tokens.begin();
  TSIterator           end=tokens.end();
  const Token         *ptr;
  while (it!=end)
  {
    ptr=*it++;
    length.expand(ptr->where);
    if (ptr->seq>=num_seq) size_.resize(num_seq=ptr->seq+1,0);
    if (!size_[ptr->seq]) size_[ptr->seq]=new Size;
    size_[ptr->seq]->expand(ptr->loc);
  }
  if (num_seq)
  {
    size=new Size[num_seq];
    for (size_t i=0; i<num_seq; ++i) if (size_[i])
    {
      size[i]=*size_[i];
      delete size_[i];
    }  
  }  
}

void
ANN::TC_set::do_put(Token &t)
{
  tokens.insert(&t);
}

bool
ANN::TC_set::do_get(Token &t)
{
  TSIterator it=tokens.find(&t);
  if (it==tokens.end()) return false;
  t.val=(*it)->val;
  return true;
}

void
ANN::TC_set::do_shrink(Token &t)
{
  TSIterator   it;
  const Token *ptr;
  for (t.seq=0; t.seq<num_seq; ++t.seq)
    while ((it=tokens.lower_bound(&t))!=tokens.end())
      if ((ptr=*it)->seq!=t.seq) break;
      {
        ptr=*it;
        tokens.erase(it);
        delete ptr;
      }
}

void
ANN::TC_set::do_erase(Token &t)
{
  TSIterator   it;
  const Token *ptr;
  while ((it=tokens.lower_bound(&t))!=tokens.end())
    if (((ptr=*it)->seq!=t.seq) || ((ptr=*it)->where!=t.where)) break;
    else
    {
      tokens.erase(it);
      delete ptr;
    }
}

void
ANN::TC_set::do_clear()
{
  TSIterator   it;
  const Token *ptr;
  while (!tokens.empty())
  {
    ptr=*(it=tokens.begin());
    tokens.erase(it);
    delete ptr;
  }
}

