/***************************************************************************
                          ann_parser_ws.cpp  -  description
                             -------------------
    begin                : pon kwi 21 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

#include <ann_parser_ws.h>
 
  //                      //
 // class ANN::Parser_ws //
//                      //

#define PARSER_WS_BUFF_LEN 1024

ANN::Parser_ws::Parser_ws()
: tc(TC::create()), seq(0), was_val(false)
{
  pos_where.inc_level();
  pos_loc.inc_level();
}

ANN::Parser_ws::~Parser_ws()
{
  if (tc) delete tc;
}

void
ANN::Parser_ws::add_val(double x)
{
  if (!was_val)
  {
    pos_where.get_loc(where);
    was_val=true;
  }
  pos_loc.get_loc(loc);
  tc->put(where,loc,x,seq);
  pos_loc.next();
}

bool
ANN::Parser_ws::add_str(const char *str, size_t len)
{
  if (len==1) switch (*str)
  {
  case '-':
  case 'X':
  case 'x':
  case '*':
    add_val(NAN);
    return true;
  }
  double  d;
  int     i;
  char   *buff=new char[len+1];
  bool    ok=true;
  strncpy(buff,str,len)[len]=0;
  if (sscanf(buff,"%lg",&d)==1) add_val(d);
  else if (sscanf(buff,"%i",&i)==1) add_val(i);
  else ok=false;
  delete [] buff;
  return ok;
}

void
ANN::Parser_ws::add_line()
{
  if (was_val)
  {
    pos_where.next();
    pos_loc.reset();
    pos_loc.inc_level();
    was_val=false;
  }
  seq=0;
}

void
ANN::Parser_ws::next_seq()
{
  pos_loc.reset();
  pos_loc.inc_level();
  ++seq;
}

bool
ANN::Parser_ws::internal_parse(std::istream &is)
{
  char   buff[PARSER_WS_BUFF_LEN];
  size_t i, l, p=0, pos=0, len=0;
  for(;;)
  {
    if (p==len)
    {
      if ((l=p-pos) && pos) for (i=0; i<l; ++i) buff[i]=buff[pos+i];
      len=p=l;
      pos=0;
      if (!(l=PARSER_WS_BUFF_LEN-len)) return false;
      if (l=is.read(buff+len,l).gcount()) len+=l;
      else return !len || add_str(buff,len);
    }
    while (p<len) switch (buff[p])
    {
    case ' ':
    case '\t':
      if (l=p-pos) if (!add_str(buff+pos,l)) return false;
      pos=++p;
      break;
    case '|':
      if (l=p-pos) if (!add_str(buff+pos,l)) return false;
      pos=++p;
      next_seq();
      break;
    case '\r':
    case '\n':
      if (l=p-pos) if (!add_str(buff+pos,l)) return false;
      pos=++p;
      add_line();
      break;
    default:
      ++p;
    }
  }
}

bool
ANN::Parser_ws::parse(std::istream &is)
{
  add_line();
  Loc last_good;
  pos_where.get_loc(last_good);
  bool ok=internal_parse(is);
  if (ok) add_line();
  else
  {
    tc->shrink(last_good);
    pos_where.reset(last_good);
  }  
  return ok;
}
