/***************************************************************************
                          ann_log_io.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <time.h>
#include <string.h>

#include <ann_log_io.h>
#include <ann_loc_io.h>

  //                   //
 // class ANN::Log_io //
//                   //

ANN::Log_io::Log_io(std::ostream &os_, const char sep_, char sub_beg_,
                    char sub_end_)
: os(&os_), marg(0), time(&Time::format), epoch(size_max),
  step_which(size_max), sep(sep_ ? sep_ : ' '), sub_beg(sub_beg_),
  sub_end(sub_end_), is_first(true), ch_epoch(false), ch_step(false)
{
}

ANN::Log_io::Log_io(Time &time_, std::ostream &os_, char sep_, char sub_beg_,
                    char sub_end_)
: os(&os_), marg(0), time(&time_), epoch(size_max), step_which(size_max),
  sep(sep_ ? sep_ : ' '), sub_beg(sub_beg_), sub_end(sub_end_),
  is_first(true), ch_epoch(false), ch_step(false)
{
}

ANN::Log_io::~Log_io()
{
  if (!is_first) *os << std::endl;
  *os << std::flush;
}

void
ANN::Log_io::write_sep()
{
  if (ch_step)
  {
    ch_step=false;
    nl(1-marg,"step starts:");
    log_uint(step_which);
    if (step_where.dim())
    {
      log_str("=>");
      log_loc(step_where);
    }  
    nl(1,0);
  }
  if (ch_epoch)
  {
    ch_epoch=false;
    nl(-marg,"epoch opens:");
    log_uint(epoch);
    nl(1,0);    
  }
  if (is_first)
  {
    time->stamp(stamp);
    *os << stamp.c_str() << '\t';
    for (int i=0; i<marg; ++i) *os << sep << sep;
    is_first=false;
  }
  else *os << sep;
}

void
ANN::Log_io::new_line(int ch_marg, const char *label)
{
  if (!is_first) *os << std::endl;
  marg+=ch_marg;
  is_first=true;
  if (label) log_str(label);
}

void
ANN::Log_io::log_chr(char chr)
{
  write_sep();
  if (chr) *os << chr;
}

void
ANN::Log_io::log_str(const char *str)
{
  write_sep();
  if (str) *os << str;
}

void
ANN::Log_io::log_int(int i)
{
  write_sep();
  *os << i;
}

void
ANN::Log_io::log_uint(unsigned int u)
{
  write_sep();
  *os << u;
}

void
ANN::Log_io::log_double(double d)
{
  write_sep();
  *os << d;
}

void
ANN::Log_io::log_loc(const Loc &loc)
{
  write_sep();
  *os << loc;
}

void
ANN::Log_io::log_size(const Size &size)
{
  write_sep();
  *os << size;
}

ANN::Time &
ANN::Log_io::get_time() const
{
  return *time;
}

char
ANN::Log_io::get_separator() const
{
  return sep;
}

char
ANN::Log_io::get_sublevel_beg() const
{
  return sub_beg;
}

char
ANN::Log_io::get_sublevel_end() const
{
  return sub_end;
}

size_t
ANN::Log_io::get_margin() const
{
  return marg;
}

void
ANN::Log_io::commence(const char *label_)
{
  step_which=epoch=size_max;
  ch_step=ch_epoch=false;
  nl(-marg,"Trainig commenced");
  if (label_)
  {
    log_str("for");
    log_str(label_);
  }
  nl(0,0);
  Log::commence(label_);
}

void
ANN::Log_io::open(size_t epoch_)
{
  epoch=epoch_;
  step_which=size_max;
  ch_epoch=true;
  ch_step=false;
  Log::open(epoch_);
}

void
ANN::Log_io::feed(size_t which_, const Loc *where_)
{
  if (which_!=size_max)
  {
    ch_step=true;
    step_which=which_;
    if (where_) step_where.resize(*where_); else step_where.resize();
  }  
  Log::feed(which_,where_);
  if (which_==size_max)   
  {
    if ((step_which!=size_max) && !ch_step)
    {
      nl(1-marg,"steps finished");
      nl(0,0);      
    }
    step_which=size_max;
    ch_step=false;
  }
}

void
ANN::Log_io::close(size_t epoch_)
{
  Log::close(epoch_);
  if ((epoch!=size_max) && !ch_epoch)
  {
    nl(-marg,"epoch closed:");
    log_uint(epoch);
    nl(0,0);
  }
  epoch=step_which=size_max;
  ch_step=ch_epoch=false;
}

void
ANN::Log_io::conclude(size_t epoch_)
{
  epoch=step_which=size_max;
  ch_step=ch_epoch=false;
  nl(-marg,"training concludes on epoch:");
  log_uint(epoch_);
  nl(1,0);
  Log::conclude(epoch_);
}

void
ANN::Log_io::concluded(size_t epoch_)
{
  Log::concluded(epoch_);
  epoch=step_which=size_max;
  ch_step=ch_epoch=false;
  nl(-marg,"training concluded on epoch:");
  log_uint(epoch_);
  nl(0,0);
}

ANN::Log &
ANN::Log_io::flush()
{
  os->flush();
  return *this;
}

