/***************************************************************************
                          ann_ds_rnd.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <math.h>

#include <ann_ds_rnd.h>

  //                   //
 // class ANN::DS_rnd //
//                   //

static void
randomize_arr(size_t *arr, size_t *arr_, size_t len)
{
  size_t pos, tmp;
  if (arr)
  {
    while (len>1)
    {
      pos=size_t((rand()/(RAND_MAX+1.0))*len);
      if (pos!=--len)
      {
        tmp=arr[len];
        arr[len]=arr[pos];
        arr[pos]=tmp;
      }
      arr_[arr[len]]=len;
    }
    arr_[arr[0]]=0;
  }  
}

ANN::DS_rnd::DS_rnd(DS &orig_)
: DS_rec(orig_), perm(0), perm_len(orig_.get_length()), current(0)
{
  if (perm_len!=size_max)
  {
    if (!perm_len) perm_len=1;
    perm=new size_t[perm_len];
    perm_=new size_t[perm_len];
    for (size_t i=0; i<perm_len; ++i) perm_[i]=perm[i]=i;
  }  
}

ANN::DS_rnd::~DS_rnd()
{
  if (perm) delete [] perm;
}

bool
ANN::DS_rnd::reset()
{
  bool ret=false;
  if (orig->reset() && (perm_len!=size_max))
  {
    randomize_arr(perm,perm_,perm_len);
    if (orig->seek(perm[current=0])) ret=true;
  }
  if (!ret) orig->feed();
  return ret;
}

void
ANN::DS_rnd::feed()
{
  bool ok;
  if (ok=(perm_len!=size_max))
    if (current<perm_len) ++current; else current=0;
  if (!ok || !(orig->seek(perm[current]))) orig->feed();
}

bool
ANN::DS_rnd::seek(size_t term_pos_)
{
  return (perm_len!=size_max)
          && orig->seek((current=term_pos_)<perm_len
                        ? perm[term_pos_] : term_pos_);
}

bool
ANN::DS_rnd::locate(const Loc &loc)
{
  if (!orig->locate(loc)) return false;
  current=orig->which();
  if ((perm_len!=size_max) && (current<perm_len)) current=perm_[current];
  return true;
}

size_t
ANN::DS_rnd::which() const
{
  return current;
}

