/***************************************************************************
                          ann_ds_frame.cpp  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include <ann_ds_frame.h>

  //                     //
 // class ANN::DS_frame //
//                     //

ANN::DS_frame::DS_frame(DS &orig_, Size size_, Size delta_)
: DS_rec(orig_), size(size_), lengths(orig->get_lengths()), current(0),
  last(size_max)
{
  buff.resize(size.shrink_back(orig->get_sizes()));
  size_t i, j, n, l=orig->get_sizes().dim()-size.dim();
  lengths.append(l,orig->get_sizes().get_coord());
  Size picture(size.dim(),orig->get_sizes().get_coord()+l);
  perm=new size_t[size.total_size()];
  Loc pos, pos_;
  for (i=0, n=size.total_size(); i<n; ++i)
  {
    size.next(pos);
    perm[i]=picture.index(pos);
  }
  Size frame_box(size.dim(),1);
  delta_.expand(frame_box);
  for (j=0, n=size.dim(); j<n; ++j)
    frame_box.set(j,(picture[j]-size[j])/delta_[j]+1);
  deltas=new size_t[frames=frame_box.total_size()];
  for (i=0; i<frames; ++i)
  {
    frame_box.next(pos_);
    for (j=0; j<n; ++j) pos[j]=pos_[j]*delta_[j];
    deltas[i]=picture.index(pos);
  }
  if (lengths.total_size()>1) lengths.append(frame_box);
  else lengths=frame_box;
  lengths.next(loc);
}

ANN::DS_frame::~DS_frame()
{
  if (perm) delete perm;
  if (deltas) delete [] deltas;
}

void
ANN::DS_frame::gather()
{
  if ((current!=last) && (current<lengths.total_size()))
  {
    size_t i, n=size.total_size();
    size_t l=orig->get_sizes().dim()-size.dim();
    if (l) orig->locate(Loc(l,loc.get_coord()));
    double       *data=buff.get_data();
    const double *data_=orig->term().get_data();
    data_+=deltas[current%frames];
    for (i=0; i<n; ++i) data[i]=data_[perm[i]];
    last=current;
  }
}

const ANN::Size &
ANN::DS_frame::get_lengths() const
{
  return lengths;
}

size_t
ANN::DS_frame::get_length() const
{
  return lengths.total_size();
}

const ANN::Size &
ANN::DS_frame::get_sizes() const
{
  return size;
}

size_t
ANN::DS_frame::get_size() const
{
  return size.total_size();
}

ANN::Term &
ANN::DS_frame::term()
{
  return buff;
}

const ANN::Term &
ANN::DS_frame::term() const
{
  return buff;
}

bool
ANN::DS_frame::reset()
{
  if (!orig->reset()) return false;
  current=0;
  loc.resize();
  lengths.next(loc);
  gather();
  return true;
}

void
ANN::DS_frame::feed()
{
  if (++current==lengths.total_size())
  {
    current=0;
    loc.resize();
  }
  lengths.next(loc);
  gather();
}

bool
ANN::DS_frame::seek(size_t term_pos_)
{
  if ((term_pos_<lengths.total_size())
      && lengths.locate(current=term_pos_,loc))
  {
    gather();
    return true;
  }
  current=size_max;
  loc.resize();
  return false;
}

bool
ANN::DS_frame::locate(const Loc &loc_)
{
  if ((current=lengths[loc_])!=size_max)
  {
    loc=loc_;
    gather();
    return true;
  }
  loc.resize();
  return false;
}

const ANN::Loc &
ANN::DS_frame::where() const
{
  return loc;
}

size_t
ANN::DS_frame::which() const
{
  return current;
}
