/***************************************************************************
                          ann_w_step.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_W_STEP_H
#define __ANN_W_STEP_H

#include <ctype.h>

#include <ann_weight.h>
#include <ann_wg_set.h>
#include <ann_wc.h>
#include <ann_w_member.h>

namespace ANN
{

  class WGC_step;
  class WG_step;
  class W_step;

  //                //
 // class WGC_step //
//                //

  class WGC_step : public WGC
  {
  public:  
    double etha;
    
    WGC_step(Log &log_, double etha_=.01) : WGC(log_), etha(etha_) {}
    WGC_step(const WGC_step &that) : WGC(that), etha(that.etha) {}    
  };
    
  //               //
 // class WG_step //
//               //

  class WG_step : public WG_set<W_step,W::Instance_t>
  {
  private:
    WG_step();
    WG_step(const WG_step &);
    
  public:
    typedef WGC_step      Common_t;
    typedef W::Instance_t Instance_t;
    typedef WG_step       Base_t;
    typedef W_step        W_t;
    
    double etha;
    
    WG_step(WGC_step &c, Instance_t inst)
    : WG(c,inst), WG_set<W_step,W::Instance_t>(c,inst), etha(c.etha) {}
    
    virtual double        get_random();
  };

  typedef FB<WG_step> WG_step_FB;
  typedef F<WG_step>  WG_step_F;
  
  //              //
 // class W_step //
//              //

  class W_step : public W
  {
  private:
    W_step();
    W_step(const W_step &);

  protected:
    TERM d;

  public:
    typedef WC<WG_step>   Common_t;
    typedef W::Instance_t Instance_t;
    typedef W             Base_t;
    typedef WG_step       WG_t;

    W_step(Common_t &c, Instance_t inst) : W(inst), d(inst->size) {}
    virtual ~W_step();

    virtual void     commence(NE &ne);
    virtual void     feed_back(const Term &d_);
    virtual void     commit(NE &ne);
    virtual WG_step &the_group() const=0;
  };

  typedef WC<WG_step>          WC_step;
  typedef F<W_member<W_step> > W_step_F;  

} // namespace ANN

#endif /* __ANN_W_STEP_H */
