/***************************************************************************
                          ann_w_mntm.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_W_MNTM_H
#define __ANN_W_MNTM_H

#include <ctype.h>

#include <ann_weight.h>
#include <ann_wg_set.h>
#include <ann_wc.h>
#include <ann_w_member.h>
#include <ann_w_step.h>

namespace ANN
{

  class WGC_mntm;
  class WG_mntm;
  class W_mntm;

  //                //
 // class WGC_mntm //
//                //

  class WGC_mntm : public WGC_step
  {
  public:
    double alpha;
    
    WGC_mntm(Log &log_, double etha_=.01, double alpha_=.9)
    : WGC_step(log_, etha_), alpha(alpha_) {}
    WGC_mntm(const WGC_mntm &that)
    : WGC_step(that), alpha(that.alpha) {}
  };

  //               //
 // class WG_mntm //
//               //

  class WG_mntm : public WG_set<W_mntm,W::Instance_t>
  {
  private:
    WG_mntm();
    WG_mntm(const WG_mntm &);

  public:
    typedef WGC_mntm      Common_t;
    typedef W::Instance_t Instance_t;
    typedef WG_mntm       Base_t;
    typedef W_mntm        W_t;

    double etha;
    double alpha;

    WG_mntm(WGC_mntm &c, Instance_t inst)
    : WG(c,inst), WG_set<W_mntm,W::Instance_t>(c,inst), etha(c.etha),
      alpha(c.alpha) {}

    virtual double        get_random();
  };

  typedef FB<WG_mntm> WG_mntm_FB;
  typedef F<WG_mntm>  WG_mntm_F;

  //              //
 // class W_mntm //
//              //

  class W_mntm : public W
  {
  private:
    W_mntm();
    W_mntm(const W_mntm &);

  protected:
    TERM d;
    TERM delta;

  public:
    typedef WC<WG_mntm>   Common_t;
    typedef W::Instance_t Instance_t;
    typedef W             Base_t;
    typedef WG_mntm       WG_t;

    W_mntm(Common_t &c, Instance_t inst)
    : W(inst), d(inst->size), delta(inst->size) {}
    virtual ~W_mntm();

    virtual void     reset(NE *ne);
    virtual void     commence(NE &ne);
    virtual void     feed_back(const Term &d_);
    virtual void     commit(NE &ne);
    virtual WG_mntm &the_group() const=0;
  };

  typedef WC<WG_mntm>          WC_mntm;
  typedef F<W_member<W_mntm> > W_mntm_F;

} // namespace ANN

#endif /* __ANN_W_MNTM_H */
