/***************************************************************************
                          ann_to_online.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TO_ONLINE_H
#define __ANN_NE_ONLINE_H

#include <ctype.h>

#include <ann_to.h>

namespace ANN
{
  class TO_online;

  //                 //
 // class TO_online //
//                 //

  class TO_online : public TO
  {
  public:
    typedef TOC         Common_t;
    typedef const Init *Instance_t;
    typedef TO          Base_t;

  private:
    TO_online();
    TO_online(const TO_online &that);

  public:
    TO_online(NIT &trainee_, DS &ds_, Log &log_, const char *label_=0)
    : TO(trainee_,ds_,log_,label_ ? label_ : "online") {}
    TO_online(NIT &trainee_, DS &ds_, Log *log_, const char *label_=0)
    : TO(trainee_,ds_,log_,label_ ? label_ : "online") {}
    TO_online(NIT &trainee_, DS &ds_, const char *label_=0)
    : TO(trainee_,ds_,label_ ? label_ : "online") {}
    TO_online(Common_t &c, Instance_t inst) : TO(c,inst) {}

    virtual ~TO_online();

  protected:
    virtual Status adapt_internal();
  };
  
  typedef F<TO_online> TO_online_F;

} //namespace ANN

#endif /* __ANN_TO_ONLINE_H */
