/***************************************************************************
                          ann_sink_xpm.h  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_SINK_XPM_H
#define __ANN_SINK_XPM_H

#include <ann_sink.h>

namespace ANN
{

  class Sink_xpm;

  //                //
 // class Sink_xpm //
//                //

  class Sink_xpm : public Sink
  {
  private:
    Sink_xpm(const Sink_xpm &that);

  protected:
    Label         var;
    size_t        var_len;
    double        black;
    double        delta;

    void init_labels(const char *label_);
    
  public:
    Sink_xpm(double black_, double white_, const char *label_=0)
    : black(black_), delta(white_-black_) { init_labels(label_); }
    Sink_xpm(double white_, const char *label_=0)
    : black(0), delta(white_) { init_labels(label_); }
    Sink_xpm(const char *label_=0)
    : black(0), delta(1) { init_labels(label_); }
    virtual ~Sink_xpm();

    virtual bool open(Size lengths, Size sizes);
    virtual bool feed(size_t which_, const Loc &where_, const Term &in,
                      const char *label=0);
    virtual bool close();
  };

} // namespace ANN

#endif /* __ANN_SINK_XPM_H */
