/***************************************************************************
                          ann_parser_log.h  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_PARSER_LOG_H
#define __ANN_PARSER_LOG_H

#include <iostream>

#include <ann_time.h>
#include <ann_tc.h>
#include <ann_ts.h>

namespace ANN
{

  class Parser_log;

  //                  //
 // class Parser_log //
//                  //

  class Parser_log
  {
  private:
    Parser_log(const Parser_log &that);

  protected:
    TC            *tc;
    std::istream  *is;
    Time          *time;
    Time::Buffer   stamp;
    time_t         last_stamp;
    char          *label;
    char         **seq_labels;
    char          *buff;
    size_t         pos;
    size_t         len;
    char           sep, sub_beg, sub_end;
    bool           after_stamp;

    void add_word(size_t seq, const Loc &where, TC::Pos &pos_loc, size_t l);
    bool load(size_t seq, const Loc &where);
    
  public:
    Parser_log(const char *label_, std::istream &is_,
               char sublevel_beg=0, char sublevel_end=0, char sep_=0);
    Parser_log(const char *label_, const char * const * seq_labels_,
               std::istream &is_,
               char sublevel_beg=0, char sublevel_end=0, char sep_=0);
    Parser_log(const char *label, std::istream &is_, Time &time_,
               char sublevel_beg=0, char sublevel_end=0, char sep_=0);
    Parser_log(const char *label, const char * const * seq_labels_,
               std::istream &is_, Time &time_,
               char sublevel_beg=0, char sublevel_end=0, char sep_=0);
    virtual ~Parser_log();

    size_t  get_seq() const { return tc->get_seq(); }
    time_t  when() const { return last_stamp; }
    void    set_separator(char sep_=0);
    char    get_separator() const { return sep; }
    void    set_sublevel(char sublevel_beg=0, char sublabel_end=0);
    bool    seek(time_t t); /* moves log pointer to point first event not
                            * former then the given time */
    bool    shift(); /* shifts one line */
    bool    find(const char *label_, char *&tail);
    /* search for a label, return the rest of the text between a new line
     * character or a term separator */
    bool    find(const char *label_);
    /* search for a label followed by a new line or a term separator */
    bool    parse(time_t end=NAV_get(time_t));
    /* parses log from the current position until time t is reached,
     * loads terms */
     
    size_t        get_seq() { return tc->get_seq(); }
    const Size   &get_lengths() { return tc->get_lengths(); }
    const size_t  get_length() { return tc->get_length(); }
    const Size   &get_sizes(size_t seq_) { return tc->get_sizes(seq_); }
    const size_t  get_size(size_t seq_) { return tc->get_size(seq_); }
    TS           *build(size_t seq_) { return tc->build(seq_); }
    void          build(Term &term, const Loc &where, size_t seq_)
    { tc->build(term,where,seq_); }
    void          shrink(const Loc &where) { tc->shrink(where); }
    void          erase(const Loc &where, size_t seq_) { tc->erase(where,seq_); }
    void          erase(const Loc &where) { tc->erase(where); }
    void          clear() { tc->clear(); }
    
    bool operator() (time_t end=NAV_get(time_t)) { return parse(end); }
  };

} // namespace ANN

#endif /* __ANN_PARSER_LOG_H */
