/***************************************************************************
                          ann_nfb_perc.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NFB_PERC_H
#define __ANN_NFB_PERC_H

#include <ann_act.h>
#include <ann_log.h>
#include <ann_factory.h>
#include <ann_nfb.h>
#include <ann_weight.h>

namespace ANN
{

  class NFBC_perc;
  class NFB_perc;
  
  //                //
 // class NFB_perc //
//                //

  class NFBC_perc
  {
  public:
    Log       *log;
    W_FB      *wf;
    const Act *act;
    Size       out_size;
    bool       bias;
    NFBC_perc(const NFBC_perc &that)
    : log(that.log), wf(that.wf), act(that.act), out_size(that.out_size),
      bias(that.bias) {}
    NFBC_perc(const Size &out_size_, Log *log_, W_FB *wf_,
              const Act &act_=Act::sigmoidal, bool bias_=true)
    : log(log_), wf(wf_), act(&act_), out_size(out_size_), bias(bias_) {}
    NFBC_perc(const Size &out_size_, Log *log_, W_FB *wf_, bool bias_)
    : log(log_), wf(wf_), act(&Act::sigmoidal), out_size(out_size_),
      bias(bias_) {}
    NFBC_perc(const Size &out_size_, W_FB *wf_, const Act &act_=Act::sigmoidal,
             bool bias_=true)
    : log(0), wf(wf_), act(&act_), out_size(out_size_), bias(bias_) {}
    NFBC_perc(const Size &out_size_, W_FB *wf_, bool bias_)
    : log(0), wf(wf_), act(&Act::sigmoidal), out_size(out_size_),
      bias(bias_) {}
  };

  //                //
 // class NFB_perc //
//                //

  class NFB_perc : public NFB
  {
  public:
    typedef NFBC_perc      Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NFB            Base_t;

  private:
    NFB_perc();
    NFB_perc(const NFB_perc &);

  protected:
    Size       out_size;
    bool       bias;
    WA         w;
    const Act *act;
    TERM       sum;
    TERM       w_grad;

  public:
    NFB_perc(NFBC_perc &c, const Init *inst);
    virtual ~NFB_perc();

    virtual const Size &get_out_sizes() const;
    virtual size_t      get_out_size() const;
    virtual void        register_weights(TO &school);
    virtual Status      close();
    virtual Status      feed(const Term &in, Term &out);
    virtual bool        fb_accept() const;
    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);
  };
  
  typedef F<NFB_perc> NFB_perc_F;

} //namespace ANN

#endif /* __ANN_NFB_PERC_H */

