/***************************************************************************
                          ann_nfb_mlayer.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NFB_MLAYER_H
#define __ANN_NFB_MLAYER_H

#include <vector>

#include <ann_nfb.h>
#include <ann_factory.h>

namespace ANN
{

  class NFBC_mlayer;
  class NFB_mlayer;

  //                   //
 // class NFBC_mlayer //
//                   //

  class NFBC_mlayer
  {
  private:
    NFBC_mlayer();

  public:
    NFB_FB **f;
    size_t   num;
    Log     *log;

    NFBC_mlayer(NFB_FB **f_, Log *log_=0)
    : f(f_), num(0), log(log_) { while (f[num]) ++num; }
    NFBC_mlayer(NFB_FB **f_, size_t num_, Log *log_=0)
    : f(f_), num(num_), log(log_) {}
    NFBC_mlayer(const NFBC_mlayer &that)
    : f(that.f), num(that.num), log(that.log) {}

    void drop_f() { while (num) delete f[--num]; }
    
    NFBC_mlayer &operator = (const NFBC_mlayer &that)
    { f=that.f; num=that.num; log=that.log; return *this; }
  };

  //                  //
 // class NFB_mlayer //
//                  //

  class NFB_mlayer : public NFB
  {
  protected:
    struct LayerData
    {
    public:
      NFB  *elem;
      TERM *in;
      TERM *in_fb;

      LayerData(NFB &elem_, NFB *former);
      ~LayerData()
      { if (elem) delete elem; if (in) delete in; if (in_fb) delete in_fb; }
    };
    typedef std::vector<LayerData *>  Layers;
    typedef Layers::iterator          L_it;
    typedef Layers::reverse_iterator  L_rit;
    typedef NFBC_mlayer               Common_t;
    typedef NFB::Instance_t           Instance_t;
    typedef NFB                       Base_t;

  private:
    NFB_mlayer();
    NFB_mlayer(const NFB_mlayer &that);
    
  protected:  
    Layers layers;

    NFB_mlayer(Log &log_, Instance_t inst) : NFB(log_,inst) {}
    NFB_mlayer(Log *log_, Instance_t inst) : NFB(log_,inst) {}
    NFB_mlayer(Instance_t inst) : NFB(inst) {}

    bool add_layer(NFB *elem_);
    bool add_layer(NFB &elem_) { return add_layer(&elem_); }
    bool add_layer(NFB_FB *factory);
    bool add_layer(NFB_FB &factory) { return add_layer(&factory); }

    template<class Iterator>
    bool build(Iterator begin, Iterator end)
    {
      for (Iterator it=begin; it!=end; ++it) if (!add_layer(*it)) return false;
      return true;
    }
    bool build(NFB_FB **arr, size_t num)
    {
      for (size_t i=0; i<num; ++i) if (!add_layer(arr[i])) return false;
      return true;
    }
    bool build(NFB_FB **arr)
    {
      while (*arr) if (add_layer(*arr)) ++arr; else return false;
      return true;
    }

  public:
    template<class Iterator>
    NFB_mlayer(Instance_t inst, Log &log_, Iterator begin, Iterator end)
    : NFB(log_,inst) { build(begin,end); }
    template<class Iterator>
    NFB_mlayer(Instance_t inst, Log *log_, Iterator begin, Iterator end)
    : NFB(log_,inst) { build(begin,end); }
    template<class Iterator>
    NFB_mlayer(Instance_t inst, Iterator begin, Iterator end)
    : NFB(inst) { build(begin,end); }
    NFB_mlayer(Instance_t inst, Log &log_, NFB_FB **factory, size_t num)
    : NFB(log_,inst) { build(factory,num); }
    NFB_mlayer(Instance_t inst, Log *log_, NFB_FB **factory, size_t num)
    : NFB(log_,inst) { build(factory,num); }
    NFB_mlayer(Instance_t inst, NFB_FB **factory, size_t num)
    : NFB(inst) { build(factory,num); }
    NFB_mlayer(Instance_t inst, Log &log_, NFB_FB **factory)
    : NFB(log_,inst) { build(factory); }
    NFB_mlayer(Instance_t inst, Log *log_, NFB_FB **factory)
    : NFB(log_,inst) { build(factory); }
    NFB_mlayer(Instance_t inst, NFB_FB **factory)
    : NFB(inst) { build(factory); }
    NFB_mlayer(NFBC_mlayer c, Instance_t inst)
    : NFB(c.log,inst) { build(c.f,c.num); }

    virtual ~NFB_mlayer();

    virtual const Size &get_out_sizes() const;
    virtual size_t      get_out_size() const;
    virtual Status      feed(const Term &in, Term &out);
    virtual void        reset(bool prod=false);
    virtual bool        load(Parser_log &parser, time_t begin=0,
                             time_t end=NAV_get(time_t));
    virtual void        store(Log &log_);
    virtual void        randomize();
    virtual void        register_weights(TO &school_);
    virtual Status      commence(DS &ds_, bool is_input);
    virtual void        conclude();
    virtual void        open();
    virtual Status      close();
    virtual bool        fb_accept() const;
    virtual void        feed_back(const Term &in, const Term &out,
                                  const Term *out_fb, Term *in_fb);

    template<class Iterator>
    static void drop_f(Iterator begin, Iterator end)
    { while(begin!=end) delete *begin++; }
    static void drop_f(NFB_FB **arr, size_t num)
    { for (size_t i=0; i<num; ++i) delete arr[i]; }
    static void drop_f(NFB_FB **arr)
    { while (*arr) delete *arr++; }
  };

  typedef F<NFB_mlayer> NFB_mlayer_F;
  
} // namespace ANN

#endif /* __ANN_NFB_MLAYER_H */
