/***************************************************************************
                          ann_manip.h  -  description
                             -------------------
    begin                : pi maj 9 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_MANIP_H
#define __ANN_MANIP_H

namespace ANN
{

  template<class Elem>
  class Manip_val;

  template<class Elem>
  class Manip_ptr_take;

  template<class Elem>
  class Manip_ptr_owner;

  //template<class Elem>//
 // class Manip_val    //
//                    //

  template<class Elem>
  class Manip_val
  {
  public:
    static void clone(Elem &lval, const Elem &rval) { lval=rval; }
    static void clear(Elem &elem) {}
    static void clear_array(Elem *arr, size_t size) {}
  };

  //template<class Elem>  //
 // class Manip_ptr_take //
//                      //

  template<class Elem>
  class Manip_ptr_take
  {
  public:
    static void clone(Elem *&lval, Elem * const &rval)
    { lval=rval; }
    static void clone(Elem *&lval, Elem *&rval)
    { lval=rval; rval=0; }
    static void clear(Elem *&elem) { if (elem) delete elem; }
    static void clear_array(Elem **arr, size_t size)
    { for (size_t i=0; i<size; ++i) if (arr[i]) delete arr[i]; }
  };

  //template<class Elem>   //
 // class Manip_ptr_owner //
//                       //

  template<class Elem>
  class Manip_ptr_owner
  {
  public:
    static void clone(Elem *&lval, const Elem * const &rval)
    { lval=(rval ? new Elem(*rval) : 0); }
    static void clear(Elem *&elem) { if (elem) delete elem; }
    static void clear_array(Elem **arr, size_t size)
    { for (size_t i=0; i<size; ++i) if (arr[i]) delete arr[i]; }
  };

} // namespace ANN

#endif /* __ANN_MANIP_H */
