/***************************************************************************
                          ann_act.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_ACT_H
#define __ANN_ACT_H

#include <math.h>
#include <ctype.h>

namespace ANN
{

  class Act;
  class Act_sigmoidal;
  class Act_linear;
  
  //           //
 // class Act //
//           //

  class Act
  {
  public:
    virtual ~Act() {}
    /* calculates activation and/or its derivatives */
    virtual double fun(const double **X, size_t order=0) const=0;
    /* X is an array of pointers to variables holding:
     * X[0] -- points to the neural potential
     * X[1] -- points to the value of the neural activation function
     * X[2] -- points to the value of the first derivative of the above
     * X[3] -- points to the value of the second derivative
     * ...     */
    
    /* general usage */
    double operator() (const double **X, size_t order=0) const
    { return fun(X,order); }
    /* calculate activation */
    double operator() (const double &x, const double &y) const
    { const double *X[]={&x, &y}; return fun(X,0); }
    /* calculate activation's derivative */
    double operator() (const double &x, const double &y, const double &y1)
                      const
    { const double *X[]={&x, &y, &y1}; return fun(X,1); }

    static Act_sigmoidal sigmoidal;  
    static Act_linear    linear;
  };
  
  //                     //
 // class Act_sigmoidal //
//                     //

  class Act_sigmoidal : public Act
  {
  public:
    virtual double fun(const double **X, size_t order=0) const;
  };
  
  //                  //
 // class Act_linear //
//                  //

  class Act_linear : public Act
  {
  public:
    virtual double fun(const double **X, size_t order=0) const;
  };

  //                     //
 // class Act_threshold //
//                     //

  class Act_threshold : public Act
  {
  protected:
    double threshold;
    double low;
    double high;
    double edge;
    
  public:
    Act_threshold(double threshold_=0, double low_=0, double high_=1,
                  double edge_=NAN)
    : threshold(threshold_), low(low_), high(high_), edge(edge_) {}
    
    virtual double fun(const double **X, size_t order=0) const;
  };

} //namespace ANN

#endif /* __ANN_ACT_H */

