/***************************************************************************
                          ann_ts.cpp  -  description
                             -------------------
    begin                : sob maj 3 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_ts.h>

  //               //
 // class ANN::TS //
//               //

ANN::TS::~TS()
{
  size_t i, n=size.total_size();
  for (i=0; i<n; ++i) delete data[i];  
}

void
ANN::TS::do_fetch(size_t size_, const Term *const *data_)
{
  size_t i;
  if (size_>size.total_size()) size_=size.total_size();
  for (i=0; i<size_; ++i) *data[i]=*data_[i];
  if (size_<size.total_size())
  {
    Term zero(term_size);
    for (i=size_; i<size.total_size(); ++i) *data[i]=zero;
  }
}

bool
ANN::TS::resize(const Size &lengths_, bool keep)
{
  size_t i, n=size.total_size(), n_=lengths_.total_size();
  for (i=n_; i<n; ++i) delete data[i];
  bool ret=Array<Term *,const Term *>::resize(lengths_);
  for (i=n; i<n_; ++i) data[i]=new Term(term_size);
  return ret;
}

bool
ANN::TS::term_resize(const Size &size_)
{
  bool   ret=(size_.total_size()==term_size.total_size());
  size_t i, n=size.total_size();
  for (i=0; i<n; ++i) data[i]->resize(size_);
  term_size=size_;
  return ret;
}

bool
ANN::TS::all_resize(const Size &lengths_, const Size &size_)
{
  size_t i, n=size.total_size(), n_=lengths_.total_size();
  for (i=n_; i<n; ++i) delete data[i];
  bool ret=Array<Term *,const Term *>::resize(lengths_)
         &&(size_.total_size()==term_size.total_size());
  if (n>n_) n=n_;
  for (i=0; i<n; ++i) data[i]->resize(size_);
  for (i=n; i<n_; ++i) data[i]=new Term(size_);
  term_size=size_;
  return ret;  
}

void
ANN::TS::import(TC &that)
{
  Loc      where;
  Loc      loc;
  Term   **terms;
  double  *dbls;
  Array<Term *,const Term *>::resize(that.get_lengths());
  term_size=that.get_sizes();
  for (terms=data; size.next(where); ++terms) if (*terms)
  {
    (*terms)->resize(term_size);
    for (dbls=(*terms)->get_data(); term_size.next(loc); ++dbls)
         *dbls=that.get(where,loc);
  }     
  else *terms=that.get_term(where);
}

ANN::TS &
ANN::TS::operator = (const TS &that)
{
  size_t             i, n=size.total_size(), n_=that.get_size();
  const Term *const *data_=that.get_data();
  for (i=n_; i<n; ++i) delete data[i];
  Array<Term *,const Term *>::resize(that.size);
  term_size=that.term_size;
  if (n>n_) n=n_;
  for (i=0; i<n; ++i) *data[i]=*data_[i];
  for (i=n; i<n_; ++i) data[i]=new Term(*data_[i]);
  return *this;
}
