/***************************************************************************
                          ann_to_online.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_to_online.h>

  //                      //
 // class ANN::TO_online //
//                      //

ANN::TO_online::~TO_online()
{
}

size_t
ANN::TO_online::train(size_t epochs)
{
  if (!ds || !elem || (ds->get_length()==size_max)) return 0;
  size_t           epoch_=0, length;
  Term             t_out(elem->get_out_sizes());
  Term             t_err;
  bool             is_superv=elem->is_supervised();
  int              fin=0;
  DS              *des_out=ds->des_output();
  ds->reset();
  length=ds->get_length();
  while ((fin<1) && (epoch_<epochs))
  {
    step=0;
    fin=0;
    if (log) log->prepare(epoch);
    elem->prepare(*this);
    for (;;)
    {
      if (log) log->stepped(step,&ds->where());
      ws->prepare(*this);
      elem->calc(ds->term(), t_out);
      elem->adapt(ds->term(), t_out, is_superv ? &des_out->term() : 0, 0);
      ws->update(*this);
      if (length<=++step) break;
      ds->next();
    }
    if (log) log->stepped(size_max,0);
    fin=trained_state(fin,elem->update(*this));
    if (log) log->update(epoch);
    ++epoch;
    ++epoch_;
    if (!ds->reset()) ds->next();
  }
  if (log) log->finish(epoch);
  ws->finish(*this);
  elem->finish(*this);
  if (log) log->finished(epoch);
  return epoch_;
}
