/***************************************************************************
                          ann_sink_xpm.cpp  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_sink_xpm.h>
#include <string.h>
#include <fstream>

static void
mk_identifier(char *str, size_t len)
{
  char   c;
  size_t i;
  for (i=0; i<len; ++i)
  {
    c=str[i];
    if (((c<'a') || ('z'<c)) && ((c<'A') || ('Z'<c)) && (c!='_') &&
        ((c<'0') || ('9'<c) || !i)) str[i]='_';
  }
}

static bool
write_xpm(std::ostream &os, const char *label, const ANN::Term &term,
          double black, double delta)
{
  size_t         height=term.get_sizes()[0];
  size_t         width=term.get_sizes()[1];
  const double  *data=term.get_data();
  unsigned char  d1, d2;
  int            j1, j2;
  os << "/* XPM */" << std::endl
     << "static char *" << label << "[]={" << std::endl
     << '\"' << width << ' ' << height << " 256 2";
  for (j1=0; j1<16; ++j1) for (j2=0; j2<16; ++j2)
  {
    if ((d1=j1)<10) d1+='0'; else d1+='a'-10;
    if ((d2=j2)<10) d2+='0'; else d2+='a'-10;
    os <<  "\"," << std::endl
       << '\"' << char(j1 + 'a') << char(j2 + 'a') << " c #"
       << d1 << d2 << d1 << d2 << d1 << d2;
  }
  for (size_t h=0; h<height; ++h)
  {
    os << "\"," << std::endl
       << '\"';
    for(size_t w=0; w<width; ++w)
    {
      double pixel=*data++-black;
      if (pixel<0) pixel=0;
      else if (pixel>delta) pixel=255;
      else pixel*=255/delta;
      d2=int(rint(pixel));
      d1=(d2 >> 4)+'a';
      d2&=0xf;
      d2+='a';
      os << d1 << d2;
    }
  }
  os << "\"};" << std::endl;
  return os;  
}

  //                     //
 // class ANN::Sink_xpm //
//                     //

ANN::Sink_xpm::~Sink_xpm()
{
}

bool
ANN::Sink_xpm::prepare(Size lengths, Size sizes, const char *label_in_,
                       const char *label_des_out_)
{
  if ((sizes.dim()!=2) || !sizes.total_size()) return false;
  const char *label;
  set_labels(label_in_,label_des_out_);
  if (!(label=strrchr(label_in.label(),'/'))) label=label_in.label();
  var_in.set_label(label);
  if (!(label=strrchr(label_des_out.label(),'/'))) label=label_des_out.label();
  var_des_out.set_label(label);
  len_l_in=label_in.length();
  len_l_des_out=label_des_out.length();
  len_v_in=var_in.length();
  len_v_des_out=var_des_out.length();
  mk_identifier(var_in.label(),len_v_in);
  mk_identifier(var_des_out.label(),len_v_des_out);
  return true;
}

bool
ANN::Sink_xpm::feed(size_t which_, const Loc &where_, const Term &in,
                    const Term *des_out)
{
  if ((in.get_sizes().dim()!=2) || !in.get_size()) return false;
  size_t i, n=where_.dim(), len_l=len_l_in, len_v=len_v_in;
  for (i=0; i<n; ++i)
  {
    label_in.set_index(where_[i],len_l,'_',0);
    len_l=label_in.length();
    var_in.set_index(where_[i],len_v,'_',0);
    len_v=var_in.length();
  }
  label_in.set_label("xpm",len_l,'.');
  var_in.set_label("xpm",len_v,'_');
  {
    std::ofstream os(label_in.label());
    if (!write_xpm(os,var_in.label(),in,black,delta)) return false;
  }  
  if (des_out)
  {
    if ((des_out->get_sizes().dim()!=2) || !des_out->get_size()) return false;
    len_l=len_l_des_out, len_v=len_v_des_out;
    for (i=0; i<n; ++i)
    {
      label_des_out.set_index(where_[i],len_l,'_',0);
      len_l=label_des_out.length();
      var_des_out.set_index(where_[i],len_v,'_',0);
      len_v=var_des_out.length();
    }
    label_des_out.set_label("xpm",len_l,'.');
    var_des_out.set_label("xpm",len_v,'_');
    std::ofstream os(label_des_out.label());
    if (!write_xpm(os,var_des_out.label(),*des_out,black,delta)) return false;    
  }
  return true;
}

bool
ANN::Sink_xpm::update()
{
  return true;
}
