/***************************************************************************
                          ann_ts.h  -  description
                             -------------------
    begin                : sob maj 3 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TS_H
#define __ANN_TS_H

#include <ann_term.h>
#include <ann_tc.h>

namespace ANN
{

  class TS; /* training sequence */

  //          //
 // class TS //
//          //
 
  class TS : public Array<Term *,const Term *>
  {
  public:
    typedef Term       *Elem_t;
    typedef const Term *Item_t;

  protected:
    Size term_size;

    virtual void do_fetch(size_t size_, const Term *const *data_);
    
  public:
    virtual bool resize(const Size &lengths_, bool keep=true);
    bool         term_resize(const Size &size_);
    bool         all_resize(const Size &lengths_, const Size &size_);
    void         import(TC &that);

    TS() {}
    TS(Size lengths_, Size size_) : term_size(size_) { resize(lengths_); }
    TS(const TS &that)
    : Array<Term *,const Term *>(), term_size(that.term_size)
    { resize(that.size); fetch(that.data); }
    TS(TC &that) { import(that); }
    virtual ~TS();

    const Size &get_lengths() const { return size; }
    size_t      get_length() const { return size.total_size(); }
    const Size &get_term_sizes() const { return term_size; }
    size_t      get_term_size() const { return term_size.total_size(); }

    TS &operator = (const TS &that);
    TS &operator = (TC &that) { import(that); return *this; }
  };

} // namespace ANN

#endif /* __ANN_TS_H */
