/***************************************************************************
                          ann_tc.h  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TC_H
#define __ANN_TC_H

#include <ann_term.h>

namespace ANN
{
  class TC; /* term collector */

  //          //
 // class TC //
//          //

  class TC
  {
  public:
    class Pos
    {
    private:
      Loc    loc;
      size_t lev;
      Pos(const Pos &that);
    public:
      Pos() : lev(0) {}
      ~Pos() {}
      void   reset() { lev=0; }
      void   reset(const Loc &loc_) { loc=loc_; lev=loc_.dim(); }
      void   inc_level();
      bool   dec_level();
      size_t get_level() const { return lev; }
      void   next() { if (lev) ++loc[lev-1]; }
      void   get_loc(Loc &loc_) const { loc_.resize(lev,loc.coord()); }
    };
    
  protected:
    struct Token
    {
      Loc    where;
      Loc    loc;
      double val;
      Token() {}
      Token(const Loc &w) : where(w) {}
      Token(const Loc &w, const Loc &l) : where(w), loc(l) {}
      Token(const Loc &w, const Loc &l, double v)
      : where(w), loc(l), val(v) {}
    };
    
    Size length;
    Size size;
    bool lim_valid;

    virtual void do_recalc()=0;
    virtual void do_put(Token &t)=0;
    virtual bool do_get(Token &t)=0;
    virtual void do_shrink(const Token &t)=0;
    virtual void do_erase(const Token &t)=0;
    virtual void do_clear()=0;    
    void         recalc();

  public:
    TC() : lim_valid(true) {}
    virtual ~TC();
    
    static TC    *create();

    void          expand(Size length_) { recalc(); length.expand(length_); }
    const Size   &get_lengths() { recalc(); return length; }
    const size_t  get_length() { recalc(); return length.total_size(); }
    const Size   &get_sizes() { recalc(); return size; }
    const size_t  get_size() { recalc(); return size.total_size(); }
    void          put(const Loc &where, const Loc &loc, double val);
    double        get(const Loc &where, const Loc &loc);
    Term         *get_term(const Loc &where);
    void          set_term(const Loc &where, Term &term);
    void          shrink(const Loc &where);
    void          erase(const Loc &where);
    void          clear();
  };
  
} // namespace ANN

#endif /* __ANN_TC_H */
