/***************************************************************************
                          ann_ne_perc.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NE_PERC_H
#define __ANN_NE_PERC_H

#include <ann_act.h>
#include <ann_log.h>
#include <ann_factory.h>
#include <ann_ne.h>
#include <ann_weight.h>

namespace ANN
{

  class NEC_perc;
  class NE_perc;
  
  //               //
 // class NE_perc //
//               //

  class NEC_perc
  {
  public:
    Log        *log;
    W_FB       *wf;
    const Act  *act;
    Size        out_size;
    bool        bias;
    NEC_perc(const NEC_perc &that)
    : log(that.log), wf(that.wf), act(that.act), out_size(that.out_size),
      bias(that.bias) {}
    NEC_perc(const Size &out_size_, Log *log_, W_FB *wf_,
             const Act &act_=Act::sigmoidal, bool bias_=true)
    : log(log_), wf(wf_), act(&act_), out_size(out_size_), bias(bias_) {}
    NEC_perc(const Size &out_size_, Log *log_, W_FB *wf_, bool bias_)
    : log(log_), wf(wf_), act(&Act::sigmoidal), out_size(out_size_),
      bias(bias_) {}
    NEC_perc(const Size &out_size_, W_FB *wf_, const Act &act_=Act::sigmoidal,
             bool bias_=true)
    : log(0), wf(wf_), act(&act_), out_size(out_size_), bias(bias_) {}
    NEC_perc(const Size &out_size_, W_FB *wf_, bool bias_)
    : log(0), wf(wf_), act(&Act::sigmoidal), out_size(out_size_),
      bias(bias_) {}
  };

  //               //
 // class NE_perc //
//               //

  class NE_perc : public NE
  {
  public:
    typedef NEC_perc       Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NE             Base_t;

  private:
    NE_perc();
    NE_perc(const NE_perc &);

  protected:
    Size        out_size;
    bool        bias;
    WA          w;
    const Act  *act;
    Term        sum;

  public:
    NE_perc(NEC_perc &c, const Init *inst);
    virtual ~NE_perc();

    virtual const Size &get_out_sizes() const;
    virtual void        reset(TO &t, bool b_reload=false);
    virtual void        calc(const Term &in, Term &out);
    virtual bool        is_supervised() const;
    virtual void        adapt(const Term &in, const Term &out,
                              const Term *out_err, Term *in_err);
  };
  
  typedef F<NE_perc> NE_perc_F;

} //namespace ANN

#endif /* __ANN_NE_PERC_H */

