/***************************************************************************
                          ann_ne_bprop.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_NE_BPROP_H
#define __ANN_NE_BPROP_H

#include <ann_ne.h>

namespace ANN
{

  class NEC_bprop;
  class NE_bprop;

  //                 //
 // class NEC_bprop //
//                 //

  class NEC_bprop
  {
  private:
    NEC_bprop();

  public:
    NE_FB  *f;
    Log    *log;
    double  threshold;
    
    NEC_bprop(NE_FB &f_, double  threshold_, Log *log_=0)
    : f(&f_), log(log_), threshold(threshold_) {}
    NEC_bprop(const NEC_bprop &that)
    : f(that.f), log(that.log), threshold(that.threshold) {}

    NEC_bprop &operator = (const NEC_bprop &that)
    { f=that.f; log=that.log; threshold=that.threshold; return *this; }    
  };

  //                //
 // class NE_bprop //
//                //

  class NE_bprop : public NE
  {
  public:
    typedef NEC_bprop      Common_t;
    typedef NE::Instance_t Instance_t;
    typedef NE             Base_t;

  private:
    NE_bprop();
    NE_bprop(const NE_bprop &that);

  protected:
    NE     *ne;
    double  error;
    Term    grad;
    char   *label_in;
    char   *label_out;
    char   *label_des_out;

  public:
    double  threshold;

    NE_bprop(NE &ne_, double threshold_, Log *log_=0, const char *label_=0);
    NE_bprop(NE &ne_, double threshold_, const char *label_);
    NE_bprop(Common_t &c, Instance_t inst);
    virtual ~NE_bprop();

    double                get_error() const { return error; }
    virtual const Size   &get_out_sizes() const;
    virtual const size_t  get_out_size() const;
    virtual void          calc(const Term &in, Term &out);

    /* Low level adaptation routines */
    virtual bool          is_supervised() const;
    /* tells whether adapt() method requires out_bp */
    virtual void          reset(TO &t, bool b_reload=false);
    /* element moves its state to the very begining of adaptation */
    virtual void          prepare(TO &t);
    /* called every time epoch starts */
    virtual int           update(TO &t);
    /* called every time epoch ends */
    virtual void          finish(TO &t);
    /* called when training is finished */
    virtual void          adapt(const Term &in, const Term &out,
                                const Term *out_bp, Term *in_bp);
    /* called after each presentation, should backpropagate errors (if needed)
     * and calculate weights' partial changes/gradients */
    virtual bool          load(Parser_log &parser, time_t begin=0,
                               time_t end=NAV_get(time_t));
    virtual void          store(Log &log_);
  };

  typedef F<NE_bprop> NE_bprop_F;
  
} //namespace ANN

#endif /* __ANN_NE_BPROP_H */
