/***************************************************************************
                          ann_ds_frame.h  -  description
                             -------------------
    begin                : nie maj 4 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_DS_FRAME_H
#define __ANN_DS_FRAME_H

#include <ann_ds_rec.h>

namespace ANN
{

  class DS_frame;

  //                //
 // class DS_frame //
//                //

  class DS_frame : public DS_rec
  {
  private:
    DS_frame();
    DS_frame(const DS_frame &that);

  protected:
    Term    buff;
    Size    size;
    Size    lengths;
    Loc     loc;
    size_t  current;
    size_t  last;
    size_t  frames;
    size_t *perm;
    size_t *deltas;

    void          gather();
    virtual bool  do_reset();
    virtual void  do_next();
    virtual bool  do_seek(size_t term_pos_);
    virtual bool  do_locate(const Loc &loc_);
    
  public:
    DS_frame(DS &orig, Size size_, Size delta_);
    virtual ~DS_frame();
    
    virtual const Size &get_lengths() const;
    virtual size_t      get_length() const;
    virtual const Size &get_sizes() const; 
    virtual size_t      get_size() const;  
    virtual Term       &term();
    virtual const Term &term() const;
    virtual const Loc  &where() const;
    virtual size_t      which() const;
    
  };

} // namespace ANN

#endif /* __ANN_DS_FRAME_H */
