#define PAM_SM_SESSION
#include <security/_pam_macros.h>
#include <security/pam_modules.h>

#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdarg.h>
#include <netdb.h>
#include <stdlib.h>
#include <dracauth.h>
#include <errno.h>

static void
lprintf(int err, const char *format,...)
{
    va_list args;
    va_start(args,format);
    openlog("pam_drac",LOG_CONS|LOG_PID,LOG_AUTH);
    vsyslog(err,format,args);
    va_end(args);
    closelog();
}

static int
pam_drac(pam_handle_t *pamh)
{
    char                *remote_host=0;
    struct hostent      *host_info=0;
    char               **addr;
    char                *err;
    struct sockaddr_in   peer_addr;
    int                  len, ret;
    u_int32_t            peer_ip;
    switch (ret=pam_get_item(pamh, PAM_RHOST, (const void **)&remote_host))
    {
    case PAM_BAD_ITEM:
    case PAM_SUCCESS:
      break;
    default:
      lprintf(LOG_ERR,"pam_drac: pam_get_item returns an error: %d",ret);
      return ret;
    }
    if (!remote_host)
    {
      len=sizeof(struct sockaddr_in);
      if (getpeername(0,(struct sockaddr *)&peer_addr,&len)<0)
      {
        lprintf(LOG_ERR,"pam_drac: getperrname returns an error: %d",errno);
        return PAM_SUCCESS;
      }
      if (!(peer_ip=peer_addr.sin_addr.s_addr)) return PAM_SUCCESS;
    }
    else if (isdigit(*remote_host)) 
    {
      if (!(peer_ip=inet_addr(remote_host))) return PAM_SUCCESS;
      remote_host=0;
    }  
    if (dracconn("localhost",&err))
    {
	lprintf(LOG_ERR,"pam_drac: dracconn (%s): %s",remote_host,err);
	return PAM_SUCCESS;
    }
    if (remote_host)
    {
	host_info=gethostbyname(remote_host);
    	if (host_info && (host_info->h_addrtype==AF_INET) 
	    && (host_info->h_length==4))
    	{
	    addr=host_info->h_addr_list;
	    while(*addr) 
		if (dracsend(((struct in_addr *)(*addr++))->s_addr,&err))
		    lprintf(LOG_ERR,"pam_drac: dracsend (%s): %s",remote_host,err);
	}
    }
    else if (dracsend(peer_ip,&err))
	lprintf(LOG_ERR,"pam_drac: dracsend (%s): %s",remote_host,err);
    if (dracdisc(&err))
	lprintf(LOG_ERR,"pam_drac: dracdisc (%s): %s",remote_host,err);
    return PAM_SUCCESS;
}

PAM_EXTERN int
pam_sm_authenticate(pam_handle_t *pamh, int flags,int argc, const char **argv)
{
  lprintf(LOG_ERR,"pam_drac: unexpected call to pam_sm_authenticate");
  return PAM_SERVICE_ERR;
}

PAM_EXTERN int
pam_sm_setcred(pam_handle_t *pamh, int flags,int argc, const char **argv)
{
  lprintf(LOG_ERR,"pam_drac: unexpected call to pam_sm_setcred");
  return PAM_SERVICE_ERR;
}

PAM_EXTERN int
pam_sm_acct_mgmt(pam_handle_t *pamh,int flags, int argc, const char **argv)
{
    return pam_drac(pamh)==PAM_SUCCESS ? PAM_SUCCESS : PAM_AUTH_ERR;
}

PAM_EXTERN int
pam_sm_open_session(pam_handle_t *pamh,int flags, int argc, const char **argv)
{
    return pam_drac(pamh)==PAM_SUCCESS ? PAM_SUCCESS : PAM_SESSION_ERR;
}

PAM_EXTERN int
pam_sm_close_session(pam_handle_t *pamh, int flags, int argc, const char **argv)
{
    return PAM_SUCCESS;
}

PAM_EXTERN int
pam_sm_chauthtok(pam_handle_t *pamh, int flags,int argc, const char **argv)
{
  lprintf(LOG_ERR,"pam_drac: unexpected call to pam_sm_chauthtok");
  return PAM_SERVICE_ERR;
}

#ifdef PAM_STATIC
struct pam_module _pam_drac_modstruct = 
{
    "pam_drac",
    pam_sm_authenticate,
    pam_sm_setcred,
    pam_sm_acct_mgmt,
    pam_sm_open_session,
    pam_sm_close_session,
    pam_sm_chauthtok,
};
#endif
