#ifndef __SETPASS_H
#define __SETPASS_H

/*
 * Copyright (C) 2002 Bartosz Lis <bartoszl@ics.p.lodz.pl>
 * This module is used to set password
 */

#define SETPASS_STAGE_MESSAGE   0
#define SETPASS_STAGE_OLD       1
#define SETPASS_STAGE_NEW       2
#define SETPASS_STAGE_NEW_AGAIN 3
#define SETPASS_STAGE_OLD_TAG       "current:"
#define SETPASS_STAGE_NEW_TAG       "new:"
#define SETPASS_STAGE_NEW_AGAIN_TAG "again:"

typedef char *(*ask_pass_t)(void *data, const char *question, int stage);

int
set_pass(void *data, const char *user, ask_pass_t ask_pass, int flags);

void 
load_prompts(const char *file);

void
free_prompts(void);

#endif /* __SETPASS_H */
