/*
 * Copyright (C) 2002-2003 Bartosz Lis <bartoszl@ics.p.lodz.pl>
 * This module is used print error messages
 */

#define _GNU_SOURCE
#include "config.h"

#include <stdio.h>

#include "errmsg.h"

char *progname;

void 
set_progname(char *progname_)
{
  progname=progname_;
}

void
error_msg (FILE *f, const char *msg, int usage, int code)
{
   if (msg) fprintf(f, "%s: %s\n",progname,msg);
   else fprintf(f, RNDPASS_STRING "\n"
                   "Generating random passwords\n"
                   "Copyright (C) 1997 - 2002 " RNDPASS_BUGREPORT "\n"
                   "This program is distributed under the GNU General Public License\n",
                   "For more information see the file COPYING in its sources\n");
   if (usage)
     {
        fprintf(f, "\nUsage: %s [-h | -v | { [<options>] [[-u] <user>]... }\n"
                   "where: -h, --help                 -- help screen\n"
                   "       -v, --version              -- version\n"
                   "       -u, --user <user>          -- change <user> password\n"
                   "                                     this option is valid for root only\n"
                   "options:\n"
                   "-L, --length <length>     -- length of the generated password\n"
                   "-U, --upper <num_upper>   -- number of upper letters in resulting password\n"
                   "-V, --vawels <string>     -- use <string> as vawels\n"
                   "-C, --consonants <string> -- use <string> as consonants\n"
                   "-q, --quiet               -- print only password\n"
                   "-s, --show                -- don't update, print only\n",
                progname);
     }
   fflush(0);
   if (code>=0) exit(code);
}

